<?php /* Template Name: Registration Template */ ?>
<?php

get_header(); ?>

<?php if (have_posts()): while (have_posts()) : the_post(); ?>

	<section class="wrapper shadow">
		<?php
		$thumb_id = get_post_thumbnail_id();
		$thumb_url_array = wp_get_attachment_image_src($thumb_id, 'thumbnail-size');
		$thumb_url = count($thumb_url_array)>0 ? $thumb_url_array[0] : '';
		if(!empty($thumb_url)) :
			?>
			<div class="featuredimageheader" style="background-image:url(<?php echo aq_resize($thumb_url,1280,200);?>);">
				<img src="<?php echo aq_resize($thumb_url,1280,200);?>"/>
			</div>
		<?php endif; ?>
		<div class="maincontent specialpage">

			<!-- section -->
			<h1><?php the_title(); ?></h1>

			<!-- article -->
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

				<?php the_content(); ?>

				<form>
					<div class="halfcol">
						<input type="text" placeholder="First Name (required)" id="firstname" name="firstname"/>
						<input type="text" placeholder="Last Name (required)" id="lastname" name="lastname"/>
						<input type="text" placeholder="Address 1" id="address1" name="address1"/>
						<input type="text" placeholder="Address 2" id="address2" name="address2"/>
						<input type="text" placeholder="Suburb" id="suburb" name="suburb"/>
						<input type="text" placeholder="State (required)" id="state" name="state"/>
						<input type="text" placeholder="Postcode (required)" id="postcode" name="postcode"/>
						<input type="text" placeholder="Phone number" id="phonenumber" name="phonenumber"/>
						<input type="text" placeholder="Fax" id="fax" name="fax"/>
						<input type="text" placeholder="Mobile (required)" id="mobile" name="mobile"/>
						<input type="text" placeholder="Email (required)" id="email" name="email"/>
						<input type="text" placeholder="Email confirmation (required)" id="email2" name="email2"/>
						<h2>Have you every tried to source 'Sir Walter DNA Certified Lawn' information from any of these?</h2>
						<label class="checkboxlbl">
							<input type="checkbox" class="checkbox" name="Sources5">Search Engine
						</label>
						<label class="checkboxlbl">
							<input type="checkbox" class="checkbox" name="Sources6">Social Media
						</label>
						<label class="checkboxlbl">
							<input type="checkbox" class="checkbox" name="Sources7">Email
						</label>
						<label class="checkboxlbl">
							<input type="checkbox" class="checkbox" name="Sources8">Website
						</label>
						<label class="checkboxlbl">
							<input type="checkbox" class="checkbox" name="Sources2">Yellow Pages
						</label>
						<label class="checkboxlbl">
							<input type="checkbox" class="checkbox" name="Sources3">the 1300 Information Phone Line
						</label>
						<label class="checkboxlbl">
							<input type="checkbox" class="checkbox" name="Sources4">A licensed Grower or Agent
						</label>

					</div>
					<div class="halfcol">
						<h2>Your Lawn</h2>
						<input type="text" placeholder="First Name (required)" id="firstname" name="firstname"/>
						<input type="text" placeholder="Purchase quantity (m&sup2;)" id="quantity" name="quantity"/>
						<input type="text" placeholder="Purchase date" id="purchasedate" name="purchasedate"/>
						<input type="text" placeholder="Certificate number" id="certificatenumber" name="certificatenumber"/>
						<input type="text" placeholder="Select how you heard of Sir Walter" id="firstname" name="firstname"/>
						<h2>On a scale of 1-5, where 1 is poor and 5 is excellent. Please rate the following:</h2>
						<label>
						<select name="AdviceReceivedRating" style="width:75px; margin-top: 5px;">
							<option value="">Select</option>
							<option value="5">5</option>
							<option value="4">4</option>
							<option value="3">3</option>
							<option value="2">2</option>
							<option value="1">1</option>
						</select>
							Information Received
						</label>
						<label>
						<select name="QualityConditionRati" style="width:75px; margin-top: 5px;">
							<option value="">Select</option>
							<option value="5">5</option>
							<option value="4">4</option>
							<option value="3">3</option>
							<option value="2">2</option>
							<option value="1">1</option></select>
							Quality/condition of Turf
						</label>
							<label>
						<select name="ServiceLevelRating" style="width:75px; margin-top: 5px;">
							<option value="">Select</option>
							<option value="5">5</option>
							<option value="4">4</option>
							<option value="3">3</option>
							<option value="2">2</option>
							<option value="1">1</option></select>
								Service
							</label>

						<h2>Have you any comments or complaints about the service your have received?</h2>
						<textarea name="Comments" cols="40" rows="6" placeholder="Your question or message"></textarea>

					</div>
					<div class="clearall"></div>
					<h2>Would you like to receive seasonal advice on keeping your
						‘Sir Walter DNA Certified Lawn’ healthy?</h2>
					<label>
					<select name="MailingList" style="width:180px">
						<option value="">Select</option>
						<option value="Y">Yes please, that would be great</option>
						<option value="N">No thanks</option></select>
					</label>
					<input class="button validate" type="submit" value="Please register my lawn"></input>
				</form>

				<?php edit_post_link(); ?>

			</article>
		</div>
	</section>
	<div class="clearall"></div>
<?php endwhile; ?>
<?php endif; ?>
</main>

<?php get_footer(); ?>

