<?php /* Template Name: Search Results */ ?>
<?php

get_header(); ?>

<?php if (have_posts()): while (have_posts()) : the_post(); ?>

	<section class="wrapper searchresults">
		<div class="maincontent specialpage" >
			<?php
				$searchObj = new SW_Search_Growers();
				$searchRes = $searchObj->search();
			?>
			<div>
				<div class="halfcol" style="padding:0;">
					<h2 style="margin-bottom:3px;">What are you looking for?</h2>
					<div><a href="<?php echo $_SERVER['REQUEST_URI'];?>&layer=0">I want to lay my own turf</a></div>
					<div><a href="<?php echo $_SERVER['REQUEST_URI'];?>&layer=1"">I need an installation expert</a></div>
				</div>
				<div class="halfcol"  style="padding:0;">
					<h3>Search for a Sir Walter DNA Certified Grower</h3>
					<form action="/search-results" class="searchform" method="get">
						<input id="submit" value="" type="submit">
						<input type="text" placeholder="Search" id="search" name="search"/><label for="submit" class="submit"><i class="fa fa-search"></i></label>
					</form>
				</div>
			</div>
			<div class="clearall"></div>
			<div class="results">
				<h1><?php echo count($searchRes);?> LICENSED SIR WALTER DNA CERTIFIED GROWERS:</h1>
				<?php foreach($searchRes as $resultItem): ?>
					<?php $regions = $searchObj->getRegionsServed($resultItem->center_id);?>
					<?php $address = [$resultItem->center_name,$resultItem->address_1,$resultItem->address_2,$resultItem->suburb,$resultItem->state,$resultItem->postcode];?>
					<div class="resultItem">
						<div>
							<h2><?php echo $resultItem->center_name;?></h2>
							<img src="http://sirwalter.com.au/growers/images/glogos/lowres/<?php echo str_replace(array('.jpg',' '),array('.gif','-'),$resultItem->image);?>"/>
						</div>
						<div>
							<?php if ($resultItem->lawnstore){?>
								<p><span class="header">Buy Our Lawncare Products</span><br/>
								<a href="http://<?php echo $resultItem->lawnstore?>"><?php echo $resultItem->lawnstore?></a></p>
							<?php } ?></p>
							<p>
								<span class="header">SUPPLYING TO THE FOLLOWING REGIONS:</span><br/>
								<?php foreach($regions as $region){
									echo $region->name.'<br/>';
								}
								?>

							</p>
						</div>
						<div>
							<span class='phone'><i class="fa fa-phone"></i><?php echo $resultItem->telephone;?></span>
							<span class='fax'><i class="fa fa-fax"></i><?php echo $resultItem->fax;?></span>
							<span class='email'><i class="fa fa-envelope"></i><a href="mailto:<?php echo $resultItem->email;?>">Email</a></span>
							<span class='website'><i class="fa fa-external-link"></i><a href="http://<?php echo $resultItem->website;?>" target="_blank">Website</a></span>
							<span class='map'><i class="fa fa-map-marker"></i><a href="http://maps.google.com/?q=<?php echo implode(' ',$address); ?> Australia" target="_blank">Directions (Map)</a></span>
						</div>
					</div>
				<?php endforeach;?>
			</div>
		</div>
	</section>
	<div class="clearall"></div>
<?php endwhile; ?>
<?php endif; ?>
</main>

<?php get_footer(); ?>

