<?php

class SW_Search_Growers
{
    protected $states;
    protected $regions;
    protected $searchFields;

    function __construct()
    {
        $this->states = array(
            'NSW' => array('name' => 'ACT & NSW', 'long_name' => 'Australian Capital Territory and New South Wales'),
            'NT' => array('name' => 'NT', 'long_name' => 'Northen Territory'),
            'QLD' => array('name' => 'QLD', 'long_name' => 'Queensland'),
            'SA' => array('name' => 'SA', 'long_name' => 'South Australia'),
            'TAS' => array('name' => 'TAS', 'long_name' => 'Tasmania'),
            'VIC' => array('name' => 'VIC', 'long_name' => 'Victoria'),
            'WA' => array('name' => 'WA', 'long_name' => 'Western Australia')
        );

        $this->regions = $this->getRegions();

        $this->searchFields = array(
            'supplier',
            'suburb',
            'state',
            'postCode',
            'web_profile_sidebar',
            'search_words'
        );

    }

    public function getAllRegionsArray()
    {
        $result = array();
        $regions = $this->getAllRegions();
        foreach($regions as $region)
        {
            if(!empty($region->regionName)) {
                $result[$region->regionState][] = array($region->regionName,$region->regionAlias);
            }
        }

        return $result;
    }

    public function getAllRegions()
    {
        global $wpdb;

        $sql = "select * from supplierregions sr";

        $results = $wpdb->get_results($sql);

        return $results;
    }

    public function getRegionsServed($grower_id)
    {
        global $wpdb;

        $sql = "
                select *
                from suppliers_supplierregions ssr
                inner join supplierregions sr
                on ssr.region_id = sr.regionID
                where ssr.supplier_id = %s";

        $results = $wpdb->get_results($wpdb->prepare($sql,$grower_id));

        return $results;


    }

    public function search()
    {
        global $wpdb;

        $search = $_REQUEST['search'];
        $state = $_REQUEST['state'];
        $layer = $_REQUEST['layer'];

        if(empty($search) && empty($state))
            return false;

        $where = ' AND (';
        $param_values = array();

        if(!empty($search))
        {
            $search_terms = array(addslashes($search));
            $search_sql = array();
            foreach ($search_terms as $term) {
                foreach ($this->searchFields as $fld) {
                    $search_sql[] = "s.`$fld` LIKE %s";
                    $param_values[] =  '%' . $wpdb->esc_like($term) . '%';
                }
            }
            $where .= implode(' OR ',$search_sql);
            $where .= ')';
        }
        else{
            $selected_region = $this->regions[$state];
            if ($selected_region) {
                $where .= ' s.`region`= %s';
                $param_values[] = $selected_region;
            } elseif ($state == 'NSW') {
                $where .= " s.`state` IN ('NSW','ACT')";
            } else {
                $where .= " s.`state` = '%s'";
                $param_values[] = $state;
            }
            $where .= ')';
        }

        $layerSql = $layer=='1' ? ' AND s.layer=1 ' : '';

        $query = 'SELECT s.*,COUNT(r.`id`) AS count_suppliers
                    FROM `suppliers` s
                    LEFT JOIN `suppliers` r ON s.`id`=r.`resell_for` AND r.`status`=1
                    WHERE s.`status`=1
                      AND s.`notgrower`=0
                      AND s.`resell_for`=0
                      AND s.id = s.supplierParent
                      AND s.`website_category`=\'Grower / Retailers\''
            .$where
            .$layerSql
            .'GROUP BY s.`id` ORDER BY trader,RAND()';

        $query2 = 'SELECT p.`supplierAlias` primary_alias,p.`publish_profile` primary_profile_published,s.*,COUNT(r.`id`) AS count_suppliers
                    FROM `suppliers` s,
                      `suppliers` p
                    LEFT JOIN `suppliers` r ON p.`id`=r.`resell_for` AND r.`status`=1
                    WHERE s.`supplierParent`=p.`id`
                      AND s.`status`=1
                      AND s.`notgrower`=0
                      AND p.`resell_for`=0
                      AND s.`website_category`=\'Grower / Retailers\''
                .$where
                .'GROUP BY s.`id` ORDER BY trader,RAND()';


        $sql = $wpdb->prepare($query,$param_values);

        $result = $wpdb->get_results($sql);

        return $result;


    }

    protected function getRegions()
    {
        global $wpdb;
        $query = "SELECT regionID, regionAlias FROM supplierregions";
        $allRegions = $wpdb->get_results($query);

        if($allRegions)
        {
            $res = array(0);
            foreach($allRegions as $region)
            {
                $res[$region->regionAlias] = $region->regionID;
            }
            return $res;
        }

        return false;

    }
}