<?php
if(!class_exists('WP_List_Table')){
    require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}

function setup_sw_customers_admin_menus() {

    add_menu_page('Sir Walter Customers', 'Registered Customers', 'manage_options',
        'sw_customers_admin', 'sw_customers_admin',null,9);

    global $pagenow;

}
add_action("admin_menu", "setup_sw_customers_admin_menus");


function sw_customers_admin() {

    $pageparams = $_GET;

    if(array_key_exists('action',$pageparams))
    {
        $action = $pageparams['action'];
        $centerid = $pageparams['center'];
        switch ($action) :
            case 'delete' :
                require_once(dirname(__FILE__) . '/swcustomers-admin-delete.php' );
                lsa_center_admin_delete();
                $wp_list_table = new LSA_Centers_List_Table();
                $wp_list_table->prepare_items();
                $wp_list_table->display();
                break;
            case 'edit' :
                require_once(dirname(__FILE__) . '/swcustomers-admin-edit.php' );
                swcustomers_admin_edit();
                break;
        endswitch;
    }
    else{
        $wp_list_table = new SWCustomers_List_Table();
        $wp_list_table->prepare_items();
        $wp_list_table->display();
    }
}


class SWCustomers_List_Table extends WP_List_Table {

    /**
     * Constructor, we override the parent to pass our own arguments
     * We usually focus on three parameters: singular and plural labels, as well as whether the class supports AJAX.
     */
    function __construct() {
        parent::__construct( array(
            'singular'=> 'wp_list_text_link', //Singular label
            'plural' => 'wp_list_test_links', //plural label, also this well be one of the table css class
            'ajax'   => false //We won't support Ajax for this table
        ) );
    }


    function extra_tablenav( $which ) {
        if ( $which == "top" ){
            //The code that goes before the table is here
            echo "<div class='wrap'>";
            echo"<H1>SW Customers</H1>";
        }
        if ( $which == "bottom" ){
            //The code that goes after the table is there
            $bob = '';
            echo "</div>";

        }
    }

    function get_columns() {
        return $columns= array(
            'CustomerID'=>__('ID'),
            'Name'=>__('Name'),
            'Postcode'=>__('Postcode'),
            'PurchaseQuantity'=>__('Quantity'),
            'CertificateNumber'=>__('CertificateNumber')
        );
    }

    public function get_sortable_columns() {
        return $sortable = array(
            'CustomerID'=>array('CustomerID',false),
            'Name'=>array('Name',false)
        );
    }


    /**
     * Prepare the table with different parameters, pagination, columns and table elements
     */
    function prepare_items() {
        global $wpdb, $_wp_column_headers;
        $screen = get_current_screen();

        /* -- Preparing your query -- */
        $query = "SELECT * FROM customers";

        /* -- Ordering parameters -- */
        //Parameters that are going to be used to order the result
        $orderby = !empty($_GET["orderby"]) ? ($_GET["orderby"]) : 'ASC';
        $order = !empty($_GET["order"]) ? ($_GET["order"]) : '';
        if(!empty($orderby) & !empty($order)){ $query.=' ORDER BY '.$orderby.' '.$order; }

        /* -- Pagination parameters -- */
        //Number of elements in your table?
        $totalitems = $wpdb->query($query); //return the total number of affected rows
        //How many to display per page?
        $perpage = 25;
        //Which page is this?
        $paged = !empty($_GET["paged"]) ? ($_GET["paged"]) : '';
        //Page Number

        if(empty($paged) || !is_numeric($paged) || $paged<=0 ){ $paged=1; }
        //How many pages do we have in total?
        $totalpages = ceil($totalitems/$perpage);
        //adjust the query to take pagination into account
        if(!empty($paged) && !empty($perpage)){
            $offset=($paged-1)*$perpage;
            $query.=' LIMIT '.(int)$offset.','.(int)$perpage;
        }

        /* -- Register the pagination -- */
        $this->set_pagination_args( array(
            "total_items" => $totalitems,
            "total_pages" => $totalpages,
            "per_page" => $perpage,
        ) );
        //The pagination links are automatically built according to those parameters

        /* -- Register the Columns -- */
        $columns = $this->get_columns();

        $this->_column_headers = array($columns, array(), $this->get_sortable_columns());

        //$_wp_column_headers[$screen->id]=$columns;


        /* -- Fetch the items -- */
        $this->items = $wpdb->get_results($query);
    }

    function column_default($item, $column_name) {
        switch ( $column_name ) {
            case "CustomerID":  return $item->CustomerID;break;
            case "Name": return stripslashes($item->Name); break;
            case "Postcode": return stripslashes($item->Postcode); break;
            case "PurchaseQuantity": return stripslashes($item->PurchaseQuantity); break;
            case "CertificateNumber" : return stripslashes($item->CertificateNumber); break;
        }

    }

    function column_Name($item) {
        $actions = array(
            'edit'      => sprintf('<a href="?page=%s&action=%s&CustomerID=%s">View</a>',$_REQUEST['page'],'edit',$item->CustomerID),
            //'delete'    => sprintf('<a href="?page=%s&action=%s&center=%s" onclick="return confirm(\'Are you sure?\')">Delete</a>',$_REQUEST['page'],'delete',$item->CustomerID),
        );

        return sprintf('%1$s %2$s', $item->Name, $this->row_actions($actions) );
    }

}