<?php


function lsa_region_admin_edit() {
    // Check that the user is allowed to update options
    if (!current_user_can('manage_options')) {
        wp_die('You do not have sufficient permissions to access this page.');
    }

    global $wpdb;

    $pageparams = $_GET;

    $region_id = $pageparams['region'];
    if (isset($_POST["region_id"])) { $region_id = $_POST["region_id"];}

    /* Save the form if it's been submitted */
    if (isset($_POST["update_region"])) {

        $region_name = esc_attr($_POST["region_name"]);
        $region_header = esc_attr($_POST["region_header"]);
        $region_parent_id = esc_attr($_POST["region_parent_id"]);
        $region_postcodes = $_POST["region_postcodes"];
        $region_content= $_POST["region_content"];

        if($region_id > 0)
        {
            //This is an existing record
            $wpdb->update(
                'wp_regions',
                array(
                    'name' => $region_name,	// string
                    'header' => $region_header,
                    'parent_id' => $region_parent_id,
                    'region_content' => $region_content
                ),
                array( 'region_id' => $region_id ),
                '%s'
                ,
                array( '%d' )
            );

            $wpdb->delete( 'wp_postcode_link', array( 'region_id' => $region_id ), null );

            foreach($region_postcodes as $postcode_id)
            {
                $wpdb->insert(
                    'wp_postcode_link',
                    array(
                        'postcode_id' => $postcode_id,	// string
                        'region_id' => $region_id
                    ),
                    '%s'
                );
            }

        }
        else
        {
            //This is a new record
            $wpdb->insert(
                'wp_regions',
                array(
                    'name' => $region_name,	// string
                    'header' => $region_header,
                    'parent_id' => $region_parent_id,
                    'region_content' => $region_content
                ),
                '%s'
            );

            $region_id = $wpdb->insert_id;

            //update links to postcodes
            foreach($region_postcodes as $postcode_id)
            {
                $wpdb->insert(
                    'wp_postcode_link',
                    array(
                        'postcode_id' => $postcode_id,	// string
                        'region_id' => $region_id
                    ),
                    '%s'
                );
            }

        }
        ?>
        <div id="message" class="updated">Saved</div>
    <?php
    }


    $results = $wpdb->get_row( $wpdb->prepare("SELECT * FROM wp_regions WHERE region_id = %d",$region_id));

    $linkListResults = $wpdb->get_results( $wpdb->prepare("SELECT wplink.link_id, wplink.region_id, wplink.postcode_id from wp_postcode_link wplink where wplink.region_id = %d", $region_id));
    $allPostcodesResults = $wpdb->get_results( $wpdb->prepare("SELECT * FROM wp_postcode",array()));
    $allRegionsResults = $wpdb->get_results( $wpdb->prepare("SELECT * FROM wp_regions WHERE region_id != %d",$region_id));


    $region_name = stripslashes($results->name);
    $region_header  = stripslashes($results->header);
    $region_parent_id = $results->parent_id;
    $region_content = stripslashes($results->region_content);

    ?>
    <div class="wrap">
        <?php screen_icon('themes'); ?> <h2>LSA Regions </h2>

        <?php echo sprintf('<a href="?page=%s">Back to List</a>',$_REQUEST['page']); ?>

        <form method="POST" action="" id="frm_lsa_region_edit">
            <input type="hidden" name="update_region" value="Y" />
            <input type="hidden" name="region_id" value="<?php echo $region_id; ?>" />
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">
                        <label for="region_name">
                            Name:
                        </label>
                    </th>
                    <td>
                        <input type="text" name="region_name" size="25" value="<?php echo $region_name;?>"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="region_parent_id">
                            Parent:
                        </label>
                    </th>
                    <td>
                        <select id="region_parent_id" name="region_parent_id">
                            <option value="0">Select a Parent Region</option>
                            <option <?php echo $region_parent_id==999999 ? ' selected ' : '';?> value="999999">City</option>
                            <?php foreach($allRegionsResults as $region)
                            {?>
                                <option <?php echo $region_parent_id==$region->region_id ? ' selected ' : '';?> value="<?php echo $region->region_id;?>"><?php echo $region->name;?></option>
                            <?php
                            }
                            ?>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="region_header">
                            Header Text:
                        </label>
                    </th>
                    <td>
                        <input type="text" name="region_header" size="25" value="<?php echo $region_header;?>"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_description">
                            Description:
                        </label>
                    </th>
                    <td>
                        <textarea id="region_content" name="region_content" cols="45" rows="10"><?php echo $region_content;?></textarea>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="region_postcodes">
                            Postcodes:
                        </label>
                    </th>
                    <td>
                        <select id="region_postcodes" name="region_postcodes[]" multiple size="10" style="width:200px;">
                            <?php foreach($allPostcodesResults as $postcode)
                            {?>
                                <?php $isLinked = isPostcodeInLinkedList($postcode->postcode_id, $linkListResults); ?>
                                <option <?php echo $isLinked==true ? ' selected ' : '';?> value="<?php echo $postcode->postcode_id;?>"><?php echo $postcode->postcode;?></option>
                            <?php
                            }
                            ?>
                        </select>
                    </td>
                </tr>
            </table>
            <p>
                <input type="submit" value="Save settings" class="button-primary"/>
            </p>
        </form>

        <script type="text/javascript">
            jQuery(document).ready(function($){

                jQuery('#frm_lsa_region_edit').validate({
                    rules: {
                        region_name : "required"
                    }
                });
            })
        </script>
    </div>
<?php

}

//work out if postcode ID is in a list of linked postcodes
function isPostcodeInLinkedList($postcode_id,$linkListResults)
{

    foreach($linkListResults as $linkListItem)
    {
        if( (int)$linkListItem->postcode_id == (int)$postcode_id)
            return true;
    }

    return false;

}
