<?php


function sw_center_admin_edit() {
    // Check that the user is allowed to update options
    if (!current_user_can('manage_options')) {
        wp_die('You do not have sufficient permissions to access this page.');
    }

    global $wpdb;

    $pageparams = $_GET;

    $center_id = $pageparams['center'];
    if (isset($_POST["center_id"])) { $center_id = $_POST["center_id"];}

    /* Save the form if it's been submitted */
    if (isset($_POST["update_center"])) {

        $center_name = esc_attr($_POST["center_name"]);
        $center_email = esc_attr($_POST["center_email"]);
        $center_telephone = esc_attr($_POST["center_telephone"]);
        $center_website = esc_attr($_POST["center_website"]);
        $center_quote = esc_attr($_POST["center_quote"]);
        $center_address1 = esc_attr($_POST["center_address1"]);
        $center_address2 = esc_attr($_POST["center_address2"]);
        $center_suburb = esc_attr($_POST["center_suburb"]);
        $center_postcode = esc_attr($_POST["center_postcode"]);
        $center_description = esc_textarea($_POST["center_description"]);
        $center_state = esc_attr($_POST["center_state"]);
        $center_grower = esc_attr($_POST["center_grower"]);
        $image = esc_attr($_POST["center_image"]);

        $center_postcodes = $_POST["center_postcodes"];
        $exclude_center_postcodes = $_POST["exclude_center_postcodes"];
        $center_regions = $_POST["center_regions"];

        if($center_id > 0)
        {
            //This is an existing record
            $wpdb->update(
                'suppliers',
                array(



                    'center_name' => $center_name,	// string
                    'email' => $center_email,
                    'telephone' => $center_telephone,
                    'website' => $center_website,
                    'quotelink' => $center_quote,
                    'address_1' => $center_address1,
                    'address_2' => $center_address2,
                    'suburb' => $center_suburb,
                    'postcode' => $center_postcode,
                    'description' => $center_description,
                    'state' => $center_state,
                    'isgrower' => $center_grower,
                    'image' => $image
                ),
                array( 'center_id' => $center_id ),
                '%s'
                ,
                array( '%d' )
            );

            $wpdb->delete( 'wp_postcode_link', array( 'center_id' => $center_id ), null );
            $wpdb->delete( 'wp_exclude_postcode_link', array( 'center_id' => $center_id ), null );
            $wpdb->delete( 'wp_region_link', array( 'center_id' => $center_id ), null );

            //update links to postcodes
            if(isset($center_postcodes))
            {
                foreach($center_postcodes as $postcode_id)
                {
                    $wpdb->insert(
                        'wp_postcode_link',
                        array(
                            'postcode_id' => $postcode_id,	// string
                            'center_id' => $center_id
                        ),
                        '%s'
                    );
                }
            }

            //update excluded postcodes
            if(isset($exclude_center_postcodes))
            {
                foreach($exclude_center_postcodes as $postcode_id)
                {
                    $wpdb->insert(
                        'wp_exclude_postcode_link',
                        array(
                            'postcode_id' => $postcode_id,	// string
                            'center_id' => $center_id
                        ),
                        '%s'
                    );
                }
            }

            //update links to regions
            if(isset($center_regions))
            {
                foreach($center_regions as $region_id)
                {
                    $wpdb->insert(
                        'wp_region_link',
                        array(
                            'region_id' => $region_id,	// string
                            'center_id' => $center_id
                        ),
                        '%s'
                    );
                }
            }


        }
        else
        {
            //This is a new record
            $wpdb->insert(
                'suppliers',
                array(
                    'center_name' => $center_name,	// string
                    'email' => $center_email,
                    'telephone' => $center_telephone,
                    'website' => $center_website,
                    'quotelink' => $center_quote,
                    'address_1' => $center_address1,
                    'address_2' => $center_address2,
                    'suburb' => $center_suburb,
                    'postcode' => $center_postcode,
                    'description' => $center_description,
                    'state' => $center_state,
                    'isgrower' => $center_grower,
                    'image' => $image
                ),
                '%s'
            );

            $center_id = $wpdb->insert_id;

            //update links to postcodes
            if(isset($center_postcode))
            {
                foreach($center_postcodes as $postcode_id)
                {
                    $wpdb->insert(
                        'wp_postcode_link',
                        array(
                            'postcode_id' => $postcode_id,	// string
                            'center_id' => $center_id
                        ),
                        '%s'
                    );
                }
            }

            //update excluded postcodes
            if(isset($exclude_center_postcodes))
            {
                foreach($exclude_center_postcodes as $postcode_id)
                {
                    $wpdb->insert(
                        'wp_exclude_postcode_link',
                        array(
                            'postcode_id' => $postcode_id,	// string
                            'center_id' => $center_id
                        ),
                        '%s'
                    );
                }
            }

            //update links to regions
            if(isset($center_regions))
            {
                foreach($center_regions as $region_id)
                {
                    $wpdb->insert(
                        'wp_region_link',
                        array(
                            'region_id' => $region_id,	// string
                            'center_id' => $center_id
                        ),
                        '%s'
                    );
                }
            }

        }

        ?>
        <div id="message" class="updated">Saved</div>
    <?php
    }


    $results = $wpdb->get_row( $wpdb->prepare("SELECT * FROM wp_centers WHERE center_id = %d",$center_id));
    $linkListResults = $wpdb->get_results( $wpdb->prepare("SELECT wplink.link_id, wplink.region_id, wplink.postcode_id from wp_postcode_link wplink where wplink.center_id = %d", $center_id));
    $excludeListResults = $wpdb->get_results( $wpdb->prepare("SELECT wplink.link_id, wplink.region_id, wplink.postcode_id from wp_exclude_postcode_link wplink where wplink.center_id = %d", $center_id));
    $allPostcodesResults = $wpdb->get_results( $wpdb->prepare("SELECT * FROM wp_postcode",array()));


    $linkRegionResults = $wpdb->get_results( $wpdb->prepare("SELECT wplink.link_id, wplink.region_id, wplink.center_id from wp_region_link wplink where wplink.center_id = %d", $center_id));
    $allRegionResults = $wpdb->get_results( $wpdb->prepare("SELECT * FROM wp_regions",array()));


    $center_name = stripslashes($results->center_name);
    $center_email = stripslashes($results->email);
    $center_telephone = stripslashes($results->telephone);
    $center_website = stripslashes($results->website);
    $center_quote = stripslashes($results->quotelink);
    $center_address1 = stripslashes($results->address_1);
    $center_address2 = stripslashes($results->address_2);
    $center_suburb = stripslashes($results->suburb);
    $center_postcode = stripslashes($results->postcode);
    $center_description = stripslashes($results->description);
    $center_state = $results->state;
    $center_isgrower = $results->isgrower;
    $image = $results->image;

    ?>
    <div class="wrap">
        <?php screen_icon('themes'); ?> <h2>Sir Walter Growers</h2>

        <?php echo sprintf('<a href="?page=%s">Back to List</a>',$_REQUEST['page']); ?>

        <form method="POST" action="" id="frm_sw_center_edit">
            <input type="hidden" name="update_center" value="Y" />
            <input type="hidden" name="center_id" value="<?php echo $center_id; ?>" />
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">
                        <label for="center_name">
                            Name:
                        </label>
                    </th>
                    <td>
                        <input type="text" name="center_name" size="25" value="<?php echo $center_name;?>"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="num_elements">
                            Image:
                        </label>
                    </th>
                    <td>
                        <input type="hidden" id="center_image" name="center_image" value="<?php echo esc_url( $image ); ?>" />
                        <input id="upload_sw_center_image_button" type="button" class="button" value="<?php _e( 'Upload Image', 'sw' ); ?>" />

                        <div id="upload_image_preview" style="min-height: 100px;">
                            <img style="max-width:100%;" src="<?php echo esc_url( $image); ?>" />
                        </div>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_grower">
                            Center Type:
                        </label>
                    </th>
                    <td>
                        <select id="center_grower" name="center_grower">
                            <option <?php echo $center_isgrower=='grower' ? ' selected ' : '';?> value="grower">Grower</option>
                            <option <?php echo $center_isgrower=='sw' ? ' selected ' : '';?> value="sw">SW Center</option>
                        </select>

                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_email">
                            Email:
                        </label>
                    </th>
                    <td>
                        <input type="text" name="center_email" size="25" value="<?php echo $center_email;?>"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_email">
                            Telephone:
                        </label>
                    </th>
                    <td>
                        <input type="text" name="center_telephone" size="25" value="<?php echo $center_telephone;?>"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_website">
                            Website:
                        </label>
                    </th>
                    <td>
                        <input type="text" name="center_website" size="25" value="<?php echo $center_website;?>"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_quote">
                            Webpage Link for Quote:
                        </label>
                    </th>
                    <td>
                        <input type="text" name="center_quote" size="25" value="<?php echo $center_quote;?>"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_address1">
                            Address 1:
                        </label>
                    </th>
                    <td>
                        <input type="text" name="center_address1" size="25" value="<?php echo $center_address1;?>"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_address2">
                            Address 2:
                        </label>
                    </th>
                    <td>
                        <input type="text" name="center_address2" size="25" value="<?php echo $center_address2;?>"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_suburb">
                            Suburb:
                        </label>
                    </th>
                    <td>
                        <input type="text" name="center_suburb" size="25" value="<?php echo $center_suburb;?>"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_postcode">
                            Postcode:
                        </label>
                    </th>
                    <td>
                        <input type="text" name="center_postcode" size="25" value="<?php echo $center_postcode;?>"/>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_state">
                            State:
                        </label>
                    </th>
                    <td>
                        <select id="center_state" name="center_state">
                            <option <?php echo $center_state=='ACT' ? ' selected ' : '';?>  value="ACT">ACT</option>
                            <option <?php echo $center_state=='NSW' ? ' selected ' : '';?>value="NSW">NSW</option>
                            <option <?php echo $center_state=='NT' ? ' selected ' : '';?>value="NT">NT</option>
                            <option <?php echo $center_state=='QLD' ? ' selected ' : '';?>value="QLD">QLD</option>
                            <option <?php echo $center_state=='SA' ? ' selected ' : '';?>value="SA">SA</option>
                            <option <?php echo $center_state=='TAS' ? ' selected ' : '';?>value="TAS">TAS</option>
                            <option <?php echo $center_state=='VIC' ? ' selected ' : '';?>value="VIC">VIC</option>
                            <option <?php echo $center_state=='WA' ? ' selected ' : '';?>value="WA">WA</option>
                        </select>

                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_description">
                            Description:
                        </label>
                    </th>
                    <td>
                        <textarea id="center_description" name="center_description" cols="25" rows="3"><?php echo $center_description;?></textarea>
                    </td>
                </tr>


                <tr valign="top">
                    <th scope="row">
                        <label for="center_regions">
                            Servicing Regions:
                        </label>
                    </th>
                    <td>
                        <select id="center_regions" name="center_regions[]" multiple size="10" style="width:200px;">
                            <?php foreach($allRegionResults as $region)
                            {?>
                                <?php $isLinked = isRegionInLinkedList($region->region_id, $linkRegionResults); ?>
                                <option <?php echo $isLinked==true ? ' selected ' : '';?> value="<?php echo $region->region_id;?>"><?php echo $region->name;?></option>
                            <?php
                            }
                            ?>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="center_postcodes">
                            Servicing Postcodes :
                            <br/>If regions not specific
                        </label>
                    </th>
                    <td>
                        <select id="center_postcodes" name="center_postcodes[]" multiple size="10" style="width:200px;">
                            <?php foreach($allPostcodesResults as $postcode)
                            {?>
                                <?php $isLinked = isPostcodeInLinkedList($postcode->postcode_id, $linkListResults); ?>
                                <option <?php echo $isLinked==true ? ' selected ' : '';?> value="<?php echo $postcode->postcode_id;?>"><?php echo $postcode->postcode;?></option>
                            <?php
                            }
                            ?>
                        </select>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row">
                        <label for="exclude_center_postcodes">
                            Exclude Postcodes :
                            <br/>These postcodes will be excluded from the search
                        </label>
                    </th>
                    <td>
                        <select id="exclude_center_postcodes" name="exclude_center_postcodes[]" multiple size="10" style="width:200px;">
                            <?php foreach($allPostcodesResults as $postcode)
                            {?>
                                <?php $isExcluded = isPostcodeInLinkedList($postcode->postcode_id, $excludeListResults); ?>
                                <option <?php echo $isExcluded==true ? ' selected ' : '';?> value="<?php echo $postcode->postcode_id;?>"><?php echo $postcode->postcode;?></option>
                                <?php
                            }
                            ?>
                        </select>
                    </td>
                </tr>
            </table>
            <p>
                <input type="submit" value="Save settings" class="button-primary"/>
            </p>
        </form>

        <script type="text/javascript">
            jQuery(document).ready(function($){

                jQuery('#frm_sw_center_edit').validate({
                    rules: {
                        center_name : "required",
                        center_email:{
                            required:true,
                            email:true
                        },
                        center_website:{ url:true}
                    }
                });

                //jQuery('#center_regions').SumoSelect({placeholder: 'Select Regions'});
                //jQuery('#center_postcodes').SumoSelect({placeholder: 'Select Postcodes'});
                //jQuery('#exclude_center_postcodes').SumoSelect({placeholder: 'Select Postcodes'});
                jQuery("#center_regions").pqSelect({
                    multiplePlaceholder: 'Select Postcodes',
                    checkbox: true //adds checkbox to options
                }).pqSelect( 'open' );
                jQuery("#center_postcodes").pqSelect({
                    multiplePlaceholder: 'Select Postcodes',
                    checkbox: true //adds checkbox to options
                }).pqSelect( 'open' );
                jQuery("#exclude_center_postcodes").pqSelect({
                    multiplePlaceholder: 'Select Postcodes',
                    checkbox: true //adds checkbox to options
                }).pqSelect( 'open' );
            })
        </script>
    </div>
<?php

}

//work out if postcode ID is in a list of linked postcodes
function isPostcodeInLinkedList($postcode_id,$linkListResults)
{

    foreach($linkListResults as $linkListItem)
    {
        if( (int)$linkListItem->postcode_id == (int)$postcode_id)
            return true;
    }

    return false;

}

//work out if region ID is in a list of linked postcodes
function isRegionInLinkedList($region_id,$linkRegionResults)
{

    foreach($linkRegionResults as $linkregionItem)
    {
        if( (int)$linkregionItem->region_id == (int)$region_id)
            return true;
    }

    return false;

}
