<?php

class SW_Search_Growers
{
    protected $states;
    protected $regions;
    protected $searchFields;

    function __construct()
    {
        $this->states = array(
            'NSW' => array('name' => 'ACT & NSW', 'long_name' => 'Australian Capital Territory and New South Wales'),
            'NT' => array('name' => 'NT', 'long_name' => 'Northen Territory'),
            'QLD' => array('name' => 'QLD', 'long_name' => 'Queensland'),
            'SA' => array('name' => 'SA', 'long_name' => 'South Australia'),
            'TAS' => array('name' => 'TAS', 'long_name' => 'Tasmania'),
            'VIC' => array('name' => 'VIC', 'long_name' => 'Victoria'),
            'WA' => array('name' => 'WA', 'long_name' => 'Western Australia')
        );

        $this->regions = $this->getRegions();

        $this->searchFields = array(
            'center_name',
            'suburb',
            'state',
            'postcode',
            'web_profile_sidebar',
            'search_words'
        );

    }

    public function getAllRegionsArray()
    {
        $result = array();
        $regions = $this->getAllRegions();
        foreach($regions as $region)
        {
            if(!empty($region->name)) {
                $result[$region->parentname][] = array($region->name,$region->region_id);
            }
        }

        return $result;
    }

    public function getAllRegions()
    {
        global $wpdb;

        $sql = "SELECT wr.region_id, wr.name, wp.name as 'parentname'
                  FROM `wp_regions` wr
                  inner join (select region_id,name from wp_regions where parent_id = 0) as wp
                  on wp.region_id = wr.parent_id";

        $results = $wpdb->get_results($sql);

        return $results;
    }

    public function getRegionsServed($grower_id)
    {
        global $wpdb;

        $sql = "
                select wr.*
                from wp_regions wr
                inner join wp_region_link wrl
                on wrl.region_id = wr.region_id
                where wrl.center_id = %s";

        $results = $wpdb->get_results($wpdb->prepare($sql,$grower_id));

        return $results;


    }

    public function search()
    {
        global $wpdb;

        $search = $_REQUEST['search'];
        $state = $_REQUEST['state'];
        $layer = $_REQUEST['layer'];
        $region = $_REQUEST['region'];

        if(empty($search) && empty($state))
            return false;

        $where = ' WHERE (';
        $param_values = array();

        if(!empty($search))
        {
            $search_terms = array(addslashes($search));
            $search_sql = array();
            foreach ($search_terms as $term) {
                foreach ($this->searchFields as $fld) {
                    $search_sql[] = "s.`$fld` LIKE %s";
                    $param_values[] =  '%' . $wpdb->esc_like($term) . '%';
                }
            }
            $where .= implode(' OR ',$search_sql);
            $where .= ' OR s.center_id in (select wrl.center_id
from wp_region_link wrl
inner join wp_postcode_link wpl
on wpl.center_id = wrl.center_id or wpl.region_id = wrl.region_id
inner join wp_postcode wp
on wp.postcode_id = wpl.postcode_id
 where wrl.center_id = s.center_id and wp.postcode = %s)';
            $param_values[] = $search;
            $where .= ')';
        }
        else{
            //$selected_region = $this->regions[$state];
            if (!is_numeric($state)) {

                $where .= ' s.center_id in (select wrl.center_id
                    from wp_region_link wrl
                    inner join wp_regions wr
                    on wr.region_id = wrl.region_id
                    left join wp_regions wp on wp.region_id = wr.parent_id
                     where wrl.center_id = s.center_id and (wr.name = %s or wp.name =%s)) or s.state=%s';

                $param_values[] = $state;
                $param_values[] = $state;
                $param_values[] = $state;

            } else {
                $where .= ' s.center_id in (select wrl.center_id
                    from wp_region_link wrl
                     where wrl.center_id = s.center_id and wrl.region_id = %s)';

                $param_values[] = $state;
            }
            $where .= ') ';
        }

        $layerSql = $layer=='1' ? ' AND s.layer=1 ' : '';

        $query = 'SELECT s.*
                    FROM `wp_centers` s'
            .$where
            .$layerSql
            .'GROUP BY s.`center_id` ORDER BY isgrower,RAND()';


        $sql = $wpdb->prepare($query,$param_values);

        $result = $wpdb->get_results($sql);

        return $result;


    }

    protected function getRegions()
    {
        global $wpdb;
        $query = "SELECT regionID, regionAlias FROM supplierregions";
        $allRegions = $wpdb->get_results($query);

        if($allRegions)
        {
            $res = array(0);
            foreach($allRegions as $region)
            {
                $res[$region->regionAlias] = $region->regionID;
            }
            return $res;
        }

        return false;

    }
}