<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
	<head>
		<meta charset="<?php bloginfo('charset'); ?>">
		<title><?php wp_title(''); ?><?php if(wp_title('', false)) { echo ' :'; } ?> <?php bloginfo('name'); ?></title>

		<link href="//www.google-analytics.com" rel="dns-prefetch">
        <link href="<?php echo get_template_directory_uri(); ?>/img/icons/favicon.ico" rel="shortcut icon">
        <!--<link href="<?php echo get_template_directory_uri(); ?>/img/icons/touch.png" rel="apple-touch-icon-precomposed">-->
		<link href="//netdna.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.css" rel="stylesheet">

		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<meta name="format-detection" content="telephone=no">

		<script type="text/javascript" src="http://fast.fonts.net/jsapi/32e4cab0-5af3-4969-b747-4222a853325b.js"></script>

		<?php wp_head(); ?>
		<script>
        // conditionizr.com
        // configure environment tests
        conditionizr.config({
            assets: '<?php echo get_template_directory_uri(); ?>',
            tests: {}
        });
        </script>

	</head>
	<body <?php body_class(); ?>>

		<!-- wrapper -->

			<!-- header -->
			<header class="header clearall" role="banner">
				<div class="wrapper">

					<!-- logo -->
					<div class="logo">
						<a href="<?php echo home_url(); ?>">
							<!-- svg logo - toddmotto.com/mastering-svg-use-for-a-retina-web-fallbacks-with-png-script -->
							<img src="<?php echo get_template_directory_uri(); ?>/img/SirWalter_Logo_Master_Web.png" alt="Logo" class="logo-img">
						</a>
					</div>
					<!-- /logo -->

					<div class="menu-wrapper">
						<div class="telephone">
							<a href="tel:<?php echo str_replace(' ','',get_theme_mod('telephone')); ?>">Ph <?php echo get_theme_mod('telephone'); ?></a>
						</div>
						<!-- nav -->
						<nav class="nav" role="navigation">
							<?php html5blank_nav(); ?>
						</nav>
						<!-- /nav -->
					</div>
					<div class="social-header">
						<a href="<?php echo get_theme_mod('facebook');?>"><i class="fa fa-facebook"></i></a>
						<a href="<?php echo get_theme_mod('youtube');?>"><i class="fa fa-youtube-play"></i></a>
						<!--<a href="<?php bloginfo('rss2_url'); ?>"><i class="fa fa-rss"></i></a>-->
					</div>
				</div>
			</header>
			<!-- /header -->
		<main role="main">
			<?php
			showSWCarousel()
			?>
