<?php /* Template Name: 2 column Template */ ?>
<?php

get_header(); ?>

<?php if (have_posts()): while (have_posts()) : the_post(); ?>

	<section class="wrapper">
		<div class="shadow leftcol equal">
			<?php
			$thumb_id = get_post_thumbnail_id();
			$thumb_url_array = wp_get_attachment_image_src($thumb_id, 'thumbnail-size');
			$thumb_url = count($thumb_url_array)>0 ? $thumb_url_array[0] : '';
			if(!empty($thumb_url)) :
				?>
				<div class="featuredimageheader" style="background-image:url(<?php echo aq_resize($thumb_url,1280,200);?>);">
					<img src="<?php echo aq_resize($thumb_url,800,200);?>"/>
				</div>
			<?php endif; ?>
			<div class="maincontent">

				<!-- section -->
				<h1><?php the_title(); ?></h1>

				<!-- article -->
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

					<?php the_content(); ?>

					<br class="clearall">

					<?php edit_post_link(); ?>

				</article>
			</div>

		</div>
		<div class="shadow rightcol equal">
			<?php
			$thumb_url = get_field('second_column_header_image');
			//$thumb_url = count($thumb_url_array)>0 ? $thumb_url_array[0] : '';
			if(!empty($thumb_url)) :
				?>
				<div class="featuredimageheader" style="background-image:url(<?php echo aq_resize($thumb_url,1280,200);?>);">
					<img src="<?php echo aq_resize($thumb_url,500,200);?>"/>
				</div>
			<?php endif; ?>
			<div class="maincontent">

				<!-- article -->
				<article id="post-<?php the_ID(); ?>-2" <?php post_class(); ?>>

					<?php echo get_field('second_column_content'); ?>

					<br class="clearall">
				</article>
			</div>
		</div>
	</section>
	<div class="clear"></div>
<?php endwhile; ?>
<?php endif; ?>
</main>

<?php get_footer(); ?>

