<?php /* Template Name: Contact Page Template */ ?>

<?php

get_header('plain'); ?>

<?php if (have_posts()): while (have_posts()) : the_post(); ?>

	<section class="wrapper shadow">
		<?php
		$thumb_id = get_post_thumbnail_id();
		$thumb_url_array = wp_get_attachment_image_src($thumb_id, 'thumbnail-size');
		$thumb_url = count($thumb_url_array)>0 ? $thumb_url_array[0] : '';
		if(!empty($thumb_url)) :
			?>
		<?php endif; ?>
		<div class="maincontent" >
			<div class="contactimage">
				<img src="<?php echo aq_resize($thumb_url,600);?>"/>
			</div>

			<div class="halfcol">
				<!-- section -->
				<!--<h1><?php the_title(); ?></h1>-->

				<!-- article -->
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

					<div class="largetext">
						<?php the_content(); ?>
					</div>

					<br class="clearall">

					<?php edit_post_link(); ?>

				</article>
			</div>
			<div class="halfcol contact-form-col">
				<h1><?php the_title(); ?></h1>
				<?php echo get_field('contact_form');?>
			</div>
			<div class="clearall"></div>
		</div>
	</section>
<?php endwhile; ?>
<?php endif; ?>
</main>

<?php get_footer(); ?>

