<?php /* Template Name: Search Page */ ?>
<?php

get_header(); ?>
	<section class="wrapper searchresults">
		<div class="maincontent specialpage searchpage" >
			<div>
				<div class="halfcol">
					<?php if (have_posts()): while (have_posts()) : the_post(); ?>
						<?php the_content();?>
					<?php endwhile; ?>
					<?php endif; ?>
				</div>
				<div class="halfcol">
					<div><img src="<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass.jpg" alt="" usemap="#Map" id="mapImg" />
						<map name="Map" id="Map">
							<area onmouseover="SW_swapImage('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_QLD.jpg')" onmouseout="SW_swapImgRestore('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass.jpg')" alt="" title="" href="/search-results?state=QLD" shape="poly" coords="403,244,534,246,547,235,565,253,594,243,587,199,520,122,488,115,471,66,440,24,421,18,407,41,394,83,384,76,377,82,378,200" />
							<area onmouseover="SW_swapImage('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_NT.jpg')" onmouseout="SW_swapImgRestore('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass.jpg')" alt="" title="" href="/search-results?state=NT" shape="poly" coords="238,53,229,198,375,204,377,72,353,55,348,21,298,16,286,9,252,29" />
							<area onmouseover="SW_swapImage('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_WA.jpg')" onmouseout="SW_swapImgRestore('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass.jpg')" alt="" title="" href="/search-results?state=WA" shape="poly" coords="226,289,83,343,46,337,28,295,43,266,7,180,35,146,188,53,233,52,236,55" />
							<area onmouseover="SW_swapImage('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_SA.jpg')" onmouseout="SW_swapImgRestore('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass.jpg')" alt="" title="" href="/search-results?state=SA" shape="poly" coords="229,291,233,201,378,206,401,246,399,374" />
							<area onmouseover="SW_swapImage('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_VIC.jpg')" onmouseout="SW_swapImgRestore('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass.jpg')" alt="" title="" href="/search-results?state=VIC" shape="poly" coords="409,379,446,392,531,383,528,369,477,342,404,312,402,375" />
							<area onmouseover="SW_swapImage('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_ACT.jpg')" onmouseover="SW_swapImage('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_NSW.jpg')"  alt="New South Wales" title="New South Wales" href="/search-results?state=NSW" shape="poly" coords="517,322,516,328,523,338,531,329,531,319,525,316,518,316" />
							<area onmouseover="SW_swapImage('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_TAS.jpg')" onmouseout="SW_swapImgRestore('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass.jpg')" alt="" title="" href="/search-results?state=TAS" shape="poly" coords="458,407,522,402,516,457,479,479,457,472,445,424" />
							<area onmouseover="SW_swapImage('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_NSW.jpg')" onmouseout="SW_swapImgRestore('mapImg','<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass.jpg')" alt="" title="" href="/search-results?state=NSW" shape="poly" coords="406,249,405,307,534,368,552,346,590,253" />
						</map>
					</div>
					<div style="margin-top:-30px;">
						<h2>Search for a Sir Walter<br/> DNA Certified Grower</h2>
						<form action="/search-results" class="searchform" method="get">
							<input id="submit" value="" type="submit">
							<input type="text" placeholder="Search" id="search" name="search"/><label for="submit" class="submit"><i class="fa fa-search"></i></label>
						</form>
					</div>
				</div>
			</div>
			<div class="clearall"></div>
			<div class="browse-region">
				<h2 class="center">FIND YOUR LOCAL SIR WALTER DNA CERTIFIED SUPPLIER BY LOCATION:</h2>
				<?php
					$sw_search = new SW_Search_Growers();
					$regions = $sw_search->getAllRegionsArray();
					foreach($regions as $topRegionName=>$topregion)
					{
						echo "<ul>";
						echo "<li><strong><a href='/search-results?state=".$topRegionName."'>".$topRegionName."</strong></a></li>";
						foreach($topregion as $subregion)
						{
							echo "<li><a href='/search-results?state=".$subregion[1]."'>".$subregion[0]."</a></li>";
						}
						echo "</ul>";
					}

				?>
			</div>
		</div>
	</section>
	<div class="clearall"></div>
</main>

<?php get_footer(); ?>
<script type="application/javascript">
	function SW_swapImgRestore($src,$img) {
		jQuery('#'+$src).attr('src',$img);
	}

	function SW_swapImage($src,$img) {
		jQuery('#'+$src).attr('src',$img)
	}

	jQuery(document).ready(function(){
		jQuery('#mapImg').rwdImageMaps();

	})

	function preload(arrayOfImages) {
		jQuery(arrayOfImages).each(function(){
			jQuery('<img/>')[0].src = this;
		});
	}

	// Usage:

	preload([
		'<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_WA.jpg',
		'<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_NT.jpg',
		'<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_SA.jpg',
		'<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_QLD.jpg',
		'<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_NSW.jpg',
		'<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_ACT.jpg',
		'<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_VIC.jpg',
		'<?php echo get_template_directory_uri(); ?>/img/AustraliaMap_Grass_TAS.jpg',
	]);


</script>

