<?php /* Template Name: Lawn Register Success Template */ ?>
<?php

get_header(); ?>

<?php
	global $wpdb;
$wpdb->show_errors();
$request = $_REQUEST;

	function stringifnull($input)
	{
		if(is_null($input))
			return '';
		return $input;
	}

	function onOffToYN($input)
	{
		$retValue = $input=='on' ? 'Y' : 'N';
		return $retValue;
	}

	$insertResult = $wpdb->insert('customers',
		array(
			'Name'=>stringifnull($request['firstname']) . ' ' . stringifnull($request['lastname']),
			'Address1'=>stringifnull($request['address1']),
			'Address2'=>stringifnull($request['address2']),
			'Suburb'=>stringifnull($request['suburb']),
			'State'=>stringifnull($request['state']),
			'Postcode'=>stringifnull($request['postcode']),
			'Phone'=>stringifnull($request['phonenumber']),
			'Fax'=>stringifnull($request['fax']),
			'Mobile'=>stringifnull($request['mobile']),
			'Email'=>stringifnull($request['email']),
			'Supplier'=>stringifnull($request['supplier']),
			'PurchaseQuantity'=>stringifnull($request['quantity']),
			'PurchaseDate'=>stringifnull($request['purchasedate']),
			'CertificateNumber'=>stringifnull($request['certificatenumber']),
			'HeardAboutVia'=>stringifnull($request['heardaboutvia']),
			'AdviceReceivedRating'=>stringifnull($request['AdviceReceivedRating']),
			'QualityConditionRating'=>stringifnull($request['QualityConditionRati']),
			'ServiceLevelRating'=>stringifnull($request['ServiceLevelRating']),
			'Comments'=>stringifnull($request['Comments']),
			'MailingList'=>stringifnull($request['MailingList']),
			'SourcedYellowPages'=>onOffToYN(stringifnull($request['Sources2'])),
			'Sourced1300Number'=>onOffToYN(stringifnull($request['Sources3'])),
			'SourcedLicencedAgent'=>onOffToYN(stringifnull($request['Sources4'])),
			'SourcedSearchEngine'=>onOffToYN(stringifnull($request['Sources5'])),
			'SourcedSocialMedia'=>onOffToYN(stringifnull($request['Sources6'])),
			'SourcedEmail'=>onOffToYN(stringifnull($request['Sources7'])),
			'SourcedWebsite'=>onOffToYN(stringifnull($request['Sources8']))
		)
	)

?>

<?php if (have_posts()): while (have_posts()) : the_post(); ?>

	<section class="wrapper shadow">
		<?php
		$thumb_id = get_post_thumbnail_id();
		$thumb_url_array = wp_get_attachment_image_src($thumb_id, 'thumbnail-size');
		$thumb_url = count($thumb_url_array)>0 ? $thumb_url_array[0] : '';
		if(!empty($thumb_url)) :
			?>
			<div class="featuredimageheader" style="background-image:url(<?php echo aq_resize($thumb_url,1280,200);?>);">
				<img src="<?php echo aq_resize($thumb_url,1280,200);?>"/>
			</div>
		<?php endif; ?>
		<div class="maincontent specialpage">

			<!-- section -->
			<h1><?php the_title(); ?></h1>

			<!-- article -->
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

				<?php if ($insertResult) : ?>
				<?php the_content(); ?>
				<?php else: ?>
					Error : please try again
				<?php endif; ?>

				<?php edit_post_link(); ?>

			</article>
		</div>
	</section>
	<div class="clearall"></div>
<?php endwhile; ?>
<?php endif; ?>
</main>

<?php get_footer(); ?>

